<?php
include 'check_ip.php';
$authorization = "Bearer {$_GET['api']}";

function add_record($zone_id,$ip,$sub,$proxy){
    global $authorization;
    if($proxy == 'false'){
        $proxy1 = false;
    }else{
        $proxy1 = true;
    }
    $record = [
        "type" => "A",
        "name" => $sub,
        "content" => $ip,
        "ttl" => 120,
        "proxied" => $proxy1
    ];
    $endpoint = "https://api.cloudflare.com/client/v4/zones/{$zone_id}/dns_records";
    
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $endpoint);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_HTTPHEADER, [
        "Authorization: {$authorization}",
        "Content-Type: application/json"
    ]);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($record));
    
    $response = curl_exec($curl);
    $info = curl_getinfo($curl);
    curl_close($curl);
    
    if ($info["http_code"] === 200) {
        return 'ok';
    }
}function del_record($zone_id,$record_id){
    global $authorization;
    $endpoint = "https://api.cloudflare.com/client/v4/zones/{$zone_id}/dns_records/{$record_id}";

    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $endpoint);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_HTTPHEADER, [
        "Authorization: {$authorization}",
        "Content-Type: application/json"
    ]);
    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "DELETE");
    
    $response = curl_exec($curl);
    $info = curl_getinfo($curl);
    curl_close($curl);

    if ($info["http_code"] === 200) {
        return 'ok';
    }
}function all_record(){
    global $authorization;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://api.cloudflare.com/client/v4/zones');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: {$authorization}",
        "Content-Type: application/json"
    ]);
    $response = curl_exec($ch);
    $status_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    if ($status_code === 200) {
        $response_data = json_decode($response, true);
        return json_encode($response_data);
    }
    curl_close($ch);
}function list_record($zoneId){
    global $authorization;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://api.cloudflare.com/client/v4/zones/{$zoneId}/dns_records");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        "Authorization: {$authorization}",
        "Content-Type: application/json"
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    curl_close($ch);
    
    $data = json_decode($response, true);
    if ($data['success']) {
        $records = $data['result'];
        return json_encode($records);
    }
}if(isset($_GET['all_recorde'])){
    print all_record();
}elseif(isset($_GET['list_recorde'])){
    print list_record($_GET['id']);
}elseif(isset($_GET['del_record'])){
    print del_record($_GET['id'],$_GET['rec']);
}elseif(isset($_GET['add_record'])){
    print add_record($_GET['id'],$_GET['ip'],$_GET['sub'],$_GET['proxy']);
}
?>