<?php


function createServer($apiToken, $serverName, $serverType, $image, $loc) {
    $url = 'https://api.digitalocean.com/v2/droplets';
    $data = array(
        'name' => $serverName,
        'region' => $loc,
        'size' => $serverType,
        'monitoring' => true,
        'image_transfer' => true,
        'install_agent' => true,
        'image' => $image,
        'user_data' => '#cloud-config
                password: MrSinza/Ir
                chpasswd: { expire: false }'
    );

    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiToken
    ));
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    
    $response = curl_exec($ch);
    curl_close($ch);
    echo $response;
}
function info($apiToken){
    $url = 'https://api.digitalocean.com/v2/droplets';
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiToken
    ));
    
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}
function deleteDroplet($apiToken, $dropletId){
    $url = 'https://api.digitalocean.com/v2/droplets/' . $dropletId;

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiToken
    ));

    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}
function traffic($apiToken,$dropletId){
    $endTimestamp = time();
    $startTimestamp = $endTimestamp - 1600;
    
    $url = "https://api.digitalocean.com/v2/monitoring/metrics/droplet/bandwidth?host_id=$dropletId&interface=public&direction=inbound&start=$startTimestamp&end=$endTimestamp";
    $ch = curl_init();
    
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            "Authorization: Bearer $apiToken"
        ]
    ]);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        echo 'Error: ' . curl_error($ch);
    } else {
        echo $response;
        $data = json_decode($response, true);
        
        $total_traffic = 0;
        foreach ($data['data']['result'][0]['values'] as $value) {
            $total_traffic += $value[1];
        }
        $total_traffic_gb = $total_traffic / (1024 * 1024 * 1024);
        $total_traffic_gb_formatted = number_format($total_traffic_gb, 10);
        return $total_traffic_gb_formatted;
    }

// Close cURL handle
curl_close($ch);
}
// echo info('dop_v1_749e1a016b9703af5b44a4bc95210b0f3cba1e2b6c6f4e920b7b31b132519aac');
// echo createServer('dop_v1_749e1a016b9703af5b44a4bc95210b0f3cba1e2b6c6f4e920b7b31b132519aac','tests','s-1vcpu-1gb','ubuntu-20-04-x64','nyc1');
echo traffic('dop_v1_749e1a016b9703af5b44a4bc95210b0f3cba1e2b6c6f4e920b7b31b132519aac','415737850');
// echo deleteDroplet('dop_v1_749e1a016b9703af5b44a4bc95210b0f3cba1e2b6c6f4e920b7b31b132519aac','415736559');