<?php
include 'check_ip.php';

$apiKey = $_GET['api'] ?: '39c6ca1f6dd19fc5327116a06bc4f0dbd05d735befab2612be9e72f441cc13fe';
function createLinodeServer($apiToken, $region, $plan, $image , $lable , $password){
    $url = 'https://api.linode.com/v4/linode/instances';

    $data = array(
        'region' => $region,
        'type' => $plan,
        'image' => $image,
        'root_pass' => $password,
        'label' => $lable
    );

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiToken
    ));

    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}

function getLinodeServers($apiToken){
    $url = 'https://api.linode.com/v4/linode/instances?page_size=500';
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiToken
    ));
    
    $response = curl_exec($ch);
    curl_close($ch);
    
    return $response;
}

function powerOffLinodeServer($apiToken, $serverId) {
    $url = "https://api.linode.com/v4/linode/instances/$serverId/shutdown";

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiToken
    ));

    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}
function powerOnLinodeServer($apiToken, $serverId) {
    $url = "https://api.linode.com/v4/linode/instances/$serverId/boot";

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiToken
    ));

    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}

function rebuild($apiToken, $serverId,$password) {
    $url = "https://api.linode.com/v4/linode/instances/$serverId/rebuild";
    
    $data = array(
        'image' => 'linode/ubuntu20.04',
        'root_pass' => $password
    );
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiToken
    ));

    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}
function deleteLinodeServer($apiToken, $linodeId) {
    $url = 'https://api.linode.com/v4/linode/instances/' . $linodeId;

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiToken
    ));

    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}
function TrafficLinodeServer($apiToken, $linodeId) {
    $url = "https://api.linode.com/v4/linode/instances/$linodeId/transfer";

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiToken
    ));

    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}
function update($apiToken, $linodeId , $name) {
    $url = "https://api.linode.com/v4/linode/instances/$linodeId";
    $data = array(
        'label' => $name
    );
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiToken
    ));

    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}
function resetpassword($apiToken, $serverId,$password) {
    $url = "https://api.linode.com/v4/linode/instances/$serverId/password";
    
    $data = array(
        'root_pass' => $password
    );
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiToken
    ));

    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}
function reboot($apiToken, $linodeId) {
    $url = "https://api.linode.com/v4/linode/instances/$linodeId/reboot";

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiToken
    ));

    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}
if(isset($_GET['create'])){
    $response = createLinodeServer($apiKey, $_GET['loc'], $_GET['server_type'], $_GET['os'],$_GET['name'],$_GET['passwords']);
    echo $response;
}if(isset($_GET['list'])){
    $response = getLinodeServers($apiKey);
    echo $response;
}if(isset($_GET['off'])){
    $response = powerOffLinodeServer($apiKey,$_GET['id']);
    echo $response;
}if(isset($_GET['on'])){
    $response = powerOnLinodeServer($apiKey,$_GET['id']);
    echo $response;
}if(isset($_GET['rebuild'])){
    $response = rebuild($apiKey,$_GET['id'],$_GET['password']);
    echo $response;
}if(isset($_GET['delete'])){
    $response = deleteLinodeServer($apiKey,$_GET['id']);
    echo $response;
}if(isset($_GET['band'])){
    $response = TrafficLinodeServer($apiKey,$_GET['id']);
    $number = json_decode($response,true);
    $terabytes = $number['used'] / pow(1024, 4);
    echo number_format($terabytes, 3);
}if(isset($_GET['update'])){
    $response = update($apiKey,$_GET['id'],$_GET['name']);
    echo $response;
}if(isset($_GET['password'])){
    $response = resetpassword($apiKey,$_GET['id'],$_GET['password']);
    echo $response;
}if(isset($_GET['reboot'])){
    $response = reboot($apiKey,$_GET['id']);
    echo $response;
}
?>