<?php

function curl_connect($url, $data = null, $headers = null, $req = 'POST') {
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);

    if ($data) {
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    }

    if ($headers) {
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    }

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    if ($req) {
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $req);
    }

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Error: ' . curl_error($ch);
    }
    curl_close($ch);
    
    return json_decode($response);
}
function bot($method, $data = []) {
    $url = 'https://api.telegram.org/bot' . TokEn_BoTs . '/' . $method;
    
    $curlOptions = [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($data),
    ];

    $curl = curl_init();
    curl_setopt_array($curl, $curlOptions);
    $res = curl_exec($curl);
    curl_close($curl);
    
    return $res;
}

function send($text,$keyboard = null){
    global $from_id;
    bot('sendMessage',[
        'chat_id'=>$from_id,
        'text'=>$text,
        'reply_markup'=>$keyboard
    ]);
}
function text($text1) {
    return ($GLOBALS['text'] === $text1);
}
function del(){
    global $from_id; global $message_id;
    bot('deletemessage', [
        'chat_id'    => $from_id,
        'message_id' => $message_id
    ]);
}
function info($plan){
    switch($plan){
case 'cx11':
            return '2-1-20-4.32';
        case 'cpx11':
            return '2-2-40-5.11';
        case 'cx21':
            return '4-2-40-6.26';
        case 'cpx21':
            return '4-3-80-8.64';
        case 'cx31':
            return '8-2-80-11';
        case 'cpx31':
            return '8-4-160-15.76';
        case 'cx41':
            return '16-4-240-20.59';
        case 'cpx41':
            return '16-8-240-30';
        case 'cax11':
            return '4-2-40-4.32';
        case 'cax21':
            return '8-4-80-7.27';
        case 'cax31':
            return '16-8-160-14.54';
        case 'cax41':
            return '32-16-320-28.44';
        case 'ccx13':
            return '8-2-80-14.4';
        case 'ccx23':
            return '16-4-160-28.22';
        case 'ccx33':
            return '32-8-240-55.94';
        default:
            return false;
    }
}
function info2($plan){
    switch($plan){
case 'cx11':
            return '2-1-20-4.75';
        case 'cpx11':
            return '2-2-40-5.62';
        case 'cx21':
            return '4-2-40-6.89';
        case 'cpx21':
            return '4-3-80-9.5';
        case 'cx31':
            return '8-2-80-12.1';
        case 'cpx31':
            return '8-4-160-17.32';
        case 'cx41':
            return '16-4-240-22.65';
        case 'cpx41':
            return '16-8-240-33';
        case 'cax11':
            return '4-2-40-4.75';
        case 'cax21':
            return '8-4-80-8';
        case 'cax31':
            return '16-8-160-16';
        case 'cax41':
            return '32-16-320-31.29';
        case 'ccx13':
            return '8-2-80-15.84';
        case 'ccx23':
            return '16-4-160-31';
        case 'ccx33':
            return '32-8-240-61.5';
        default:
            return false;
    }
}
function info3($plan){
    switch($plan){
case 'cx11':
            return '2-1-20-4.75';
        case 'cpx11':
            return '2-2-40-5.62';
        case 'cx21':
            return '4-2-40-6.89';
        case 'cpx21':
            return '4-3-80-9.5';
        case 'cx31':
            return '8-2-80-12.1';
        case 'cpx31':
            return '8-4-160-17.32';
        case 'cx41':
            return '16-4-240-22.65';
        case 'cpx41':
            return '16-8-240-33';
        case 'cax11':
            return '4-2-40-4.75';
        case 'cax21':
            return '8-4-80-8';
        case 'cax31':
            return '16-8-160-16';
        case 'cax41':
            return '32-16-320-31.29';
        case 'ccx13':
            return '8-2-80-15.84';
        case 'ccx23':
            return '16-4-160-31';
        case 'ccx33':
            return '32-8-240-61.5';
        default:
            return false;
    }
}
function location($loc){
    switch($loc){
        case '1':
            return '🇩🇪 falkentein';
        case '2':
            return '🇩🇪 nuremberg';
        case '3':
            return '🇫🇮 helsinki';
        case '4':
            return '🇺🇸 Ashburn';
        case '5':
            return '🇺🇸 Hillsboro';
        default:
            return false;
    }
}
function linode($plan){
    switch($plan){
        case 'g6-nanode-1':
            return '1-1-25-1-5';
        case 'g6-standard-1':
            return '2-1-50-2-12';
        case 'g6-standard-2':
            return '4-2-80-4-24';
        case 'g6-standard-4':
            return '8-4-160-5-48';
        case 'g6-standard-6':
            return '16-6-320-8-96';
        case 'g6-standard-8':
            return '32-8-640-16-192';
        default:
            return false;
    }
}
function loclinode($loc){
    switch($loc){
        case 'se-sto':
            return '🇸🇪 Stockholm';
        case 'us-iad':
            return '🇺🇸 Washington';
        case 'ca-central':
            return '🇨🇦 Toronto';
        case 'nl-ams':
            return '🇳🇱 Amsterdam';
        case 'it-mil':
            return '🇮🇹 Milan';
        case 'eu-west':
            return '🇬🇧 London';
        case 'fr-par':
            return '🇫🇷 Paris';
        case 'eu-central':
            return '🇩🇪 Frankfurt';
        case 'ap-south':
            return '🇸🇬 Singapore';
        case 'ap-west':
            return '🇮🇳 Mumbai';
        case 'ap-northeast';
            return '🇯🇵 Tokyo';
        case 'br-gru':
            return '🇧🇷 Sao Paulo';
        case 'id-cgk':
            return '🇮🇩 Jakarta';
        case 'ap-southeast':
            return'🇦🇺 Sydney';
        default:
            return false;
    }
}
function vultr($plan){
    switch($plan){
        case 'vc2-1c-1gb':
            return '1-1-25-1-5';
        case 'vc2-1c-2gb':
            return '2-1-55-2-10';
        case 'vc2-2c-4gb':
            return '4-2-80-3-20';
        case 'vc2-4c-8gb':
            return '8-4-160-4-40';
        case 'vhp-1c-1gb-intel':
            return '1-1-25-2-6';
        case 'vhp-1c-2gb-intel':
            return '2-1-50-3-12';
        case 'vhp-1c-1gb-amd':
            return '1-1-25-2-6';
        case 'vhp-1c-2gb-amd':
            return '2-1-50-3-12';
        default:
            return false;
    }
}
function vultr2($plan){
    switch($plan){
        case 'vc2-1c-1gb':
            return '1-1-25-1-6';
        case 'vc2-1c-2gb':
            return '2-1-55-2-12';
        case 'vc2-2c-4gb':
            return '4-2-80-3-23';
        case 'vc2-4c-8gb':
            return '8-4-160-4-46';
        default:
            return false;
    }
}
function locvultr($loc){
    switch($loc){
        case 'cdg':
            return '🇫🇷 Paris';
        case 'ams':
            return '🇳🇱 Amsterdam';
        case 'lhr':
            return '🇬🇧 London';
        case 'fra':
            return '🇩🇪 Frankfurt';
        case 'mad':
            return '🇪🇸 Madrid';
        case 'man':
            return '🇬🇧 Manchester';
        case 'sto':
            return '🇸🇪 Stockholm';
        case 'waw':
            return '🇵🇱 Warsaw';
        case 'mia':
            return '🇺🇸 Miami';
        case 'sgp':
            return '🇸🇬 Singapore';
        case 'bom':
            return '🇮🇳 Mumbai';
        case 'jnb':
            return '🇿🇦 Johannesburg';
        case 'icn':
            return '🇰🇷 Seoul';
        case 'nrt':
            return '🇯🇵 Tokyo';
        case 'sao':
            return '🇧🇷 São Paulo';
        case 'mel':
            return '🇦🇺 Melbourne';
        case 'mex':
            return '🇲🇽 Mexico City';
        case 'scl':
            return '🇨🇱 Santiago';
        default:
            return false;
    }
}


function vitua($plan){
    switch($plan){
        case 'vcs-1-ryzen':
            return '1-1-20-8.4';
        case 'vcs-2-intel':
            return '2-1-40-14.4';
        case 'vcs-1-intel':
            return '1-1-20-6';
        case 'vcs-start-intel':
            return '0.5-1-10-3.2';
        case 'vcs-1-intel':
            return '2-1-55-7.2';
        default:
            return false;
    }
}
function locvitua($plan){
    switch($plan){
        case 'par01fr':
            return '🇫🇷 Paris';
        case 'lil01fr':
            return '🇫🇷 Lille';
        case 'fmt02us':
            return '🇺🇸 Fremont';
        default:
            return false;
    }
}
function ovh($plan){
    switch($plan){
        case 'd2-2':
            return '2-1-25-8.6';
        case 'd2-4':
            return '4-2-50-17';
        case 'd2-8':
            return '8-4-50-31';
        default:
            return false;
    }
}
function locovh($plan){
    switch($plan){
        case 'BHS5':
            return '🇨🇦 Beauharnois';
        case 'DE1':
            return '🇩🇪 Frankfurt';
        case 'GRA11':
            return '🇫🇷 Gravelines';
        case 'RBX-A':
            return '🇫🇷 Roubaix';
        case 'SBG5':
            return '🇫🇷 Strasbourg';
        case 'UK1':
            return '🇬🇧 London';
        case 'WAW1':
            return '🇵🇱 Warsaw';
        default:
            return false;
    }
}
function gcore($plan){
    switch($plan){
        case 'g2s-shared-1-1-25':
            return '1-1-25-5';
        case 'g2s-shared-1-2-25':
            return '2-1-25-7';
        default:
            return false;
    }
}
function ipv4_encode($text) {
    $conversionTable = array(
        '1' => 'a',
        '2' => 'b',
        '3' => 'c',
        '4' => 'd',
        '5' => 'e',
        '6' => 'f',
        '7' => 'j',
        '8' => 'h',
        '9' => 'i',
        '0' => 'k',
        '.' => 'p',
    );

    $convertedText = str_replace(".", "p", $text);

    return str_replace(array_keys($conversionTable), array_values($conversionTable), $convertedText);
}
function ipv4_decode($text) {
    $text = str_replace(".cloudsnap.online", null, $text);
    $conversionTable = array(
        'a' => '1',
        'b' => '2',
        'c' => '3',
        'd' => '4',
        'e' => '5',
        'f' => '6',
        'j' => '7',
        'h' => '8',
        'i' => '9',
        'k' => '0',
        'p' => '.',
    );

    $decodedText = str_replace(array_keys($conversionTable), array_values($conversionTable), $text);

    return $decodedText;
}

function limit($limit){
    global $from_id;
    $list_servers = json_decode(file_get_contents('include/list_server.json'),true);
    
    $hetzner1 = $list_servers['hetzner'];
    $hetzner2 = $list_servers['hetzner2'];
    $hetzner3 = $list_servers['hetzner3'];
    
    $linode1 = $list_servers['linode'];
    $linode2 = $list_servers['linode2'];
    
    $vultr1 = $list_servers['vultr'];
    $vultr2 = $list_servers['vultr2'];
    
    $virtua1 = $list_servers['virtua'];
    $ovh1 = $list_servers['ovh'];
    
    $payhorly = 0;
    $gcore1 = $list_servers['gcore1'];
    $gcore2 = $list_servers['gcore2'];
    $gcore3 = $list_servers['gcore3'];
    foreach ($gcore1['results'] as $match) {
        if(strpos($match['instance_name'],"$from_id") !== false){
            $lim++;
        }
    }
    foreach ($gcore2['results'] as $match) {
        if(strpos($match['instance_name'],"$from_id") !== false){
            $lim++;
        }
    }
    foreach ($gcore3['results'] as $match) {
        if(strpos($match['instance_name'],"$from_id") !== false){
            $lim++;
        }
    }
    foreach ($hetzner1 as $match) {
        if(strpos($match['name'],"$from_id") !== false){
            $lim++;
        }
    }
    foreach ($hetzner2 as $match) {
        if(strpos($match['name'],"$from_id") !== false){
            $lim++;
        }
    }
    foreach ($hetzner3 as $match) {
        if(strpos($match['name'],"$from_id") !== false){
            $lim++;
        }
    }

    foreach ($linode1['data'] as $server) {
        if(strpos($server['label'],"$from_id") !== false){
            $lim++;
        }
    }

    foreach ($vultr1['instances'] as $droplet) {
        if(strpos($droplet['label'], "$from_id") !== false){
            $lim++;
        }
    }
    
    foreach ($virtua1['cloud_servers'] as $server) {
        if(strpos($server['label'], "$from_id") !== false){
            $lim++;
        }
    }
    
    foreach ($ovh1 as $server) {
        if(strpos($server['name'], "$from_id") !== false){
            $lim++;
        }
    }
    
    # Cracky
    
    foreach ($linode2['data'] as $server) {
        if(strpos($server['label'],"$from_id") !== false){
            $lim++;
        }
    }
    
    
    foreach ($vultr2['instances'] as $droplet) {
        if(strpos($droplet['label'], "$from_id") !== false){
            $lim++;
        }
    }
    if($lim >= $limit){
        return true;
    }
}
function ping($ipv4){
    $ping = exec("ping $ipv4 -c 1");
    $ms = explode("/",$ping)[4];
    if($ms != null){
        return "✅ Ms : $ms";
    }else{
        return "❌ No Ping";
    }
}
