<?php

ini_set('max_execution_time','250');
set_time_limit(250);
ini_set('memory_limit' , '-1');
error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'database.php';

function bot($method, $data = []){
    $url  = 'https://api.telegram.org/bot'. TokEn_BoTs. '/'.$method;
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
    $res = curl_exec($curl);
    curl_close($curl);
    return $res;
}

function info($plan){
    switch($plan){
        case 'cx11':
            return '2-1-20-4.32';
        case 'cpx11':
            return '2-2-40-5.11';
        case 'cx21':
            return '4-2-40-6.26';
        case 'cpx21':
            return '4-3-80-8.64';
        case 'cx31':
            return '8-2-80-11';
        case 'cpx31':
            return '8-4-160-15.76';
        case 'cx41':
            return '16-4-240-20.59';
        case 'cpx41':
            return '16-8-240-30';
        case 'cax11':
            return '4-2-40-4.32';
        case 'cax21':
            return '8-4-80-7.27';
        case 'cax31':
            return '16-8-160-14.54';
        case 'cax41':
            return '32-16-320-28.44';
        case 'ccx13':
            return '8-2-80-14.4';
        case 'ccx23':
            return '16-4-160-28.22';
        case 'ccx33':
            return '32-8-240-55.94';
        default:
            return false;
    }
}
function info2($plan){
    switch($plan){
        case 'cx11':
            return '2-1-20-4.75';
        case 'cpx11':
            return '2-2-40-5.62';
        case 'cx21':
            return '4-2-40-6.89';
        case 'cpx21':
            return '4-3-80-9.5';
        case 'cx31':
            return '8-2-80-12.1';
        case 'cpx31':
            return '8-4-160-17.32';
        case 'cx41':
            return '16-4-240-22.65';
        case 'cpx41':
            return '16-8-240-33';
        case 'cax11':
            return '4-2-40-4.75';
        case 'cax21':
            return '8-4-80-8';
        case 'cax31':
            return '16-8-160-16';
        case 'cax41':
            return '32-16-320-31.29';
        case 'ccx13':
            return '8-2-80-15.84';
        case 'ccx23':
            return '16-4-160-31';
        case 'ccx33':
            return '32-8-240-61.5';
        default:
            return false;
    }
}

function info3($plan){
    switch($plan){
        case 'cx11':
        case 'cx11':
            return '2-1-20-4.75';
        case 'cpx11':
            return '2-2-40-5.62';
        case 'cx21':
            return '4-2-40-6.89';
        case 'cpx21':
            return '4-3-80-9.5';
        case 'cx31':
            return '8-2-80-12.1';
        case 'cpx31':
            return '8-4-160-17.32';
        case 'cx41':
            return '16-4-240-22.65';
        case 'cpx41':
            return '16-8-240-33';
        case 'cax11':
            return '4-2-40-4.75';
        case 'cax21':
            return '8-4-80-8';
        case 'cax31':
            return '16-8-160-16';
        case 'cax41':
            return '32-16-320-31.29';
        case 'ccx13':
            return '8-2-80-15.84';
        case 'ccx23':
            return '16-4-160-31';
        case 'ccx33':
            return '32-8-240-61.5';
        default:
            return false;
    }
}
     

function linode($plan){
    switch($plan){
        case 'g6-nanode-1':
            return '1-1-25-1-5';
        case 'g6-standard-1':
            return '2-1-50-2-12';
        case 'g6-standard-2':
            return '4-2-80-4-24';
        case 'g6-standard-4':
            return '8-4-160-5-48';
        case 'g6-standard-6':
            return '16-6-320-8-96';
        case 'g6-standard-8':
            return '32-8-640-16-192';
        default:
            return false;
    }
}
function vultr($plan){
    switch($plan){
        case 'vc2-1c-1gb':
            return '1-1-25-1-5';
        case 'vc2-1c-2gb':
            return '2-1-55-2-10';
        case 'vc2-2c-4gb':
            return '4-2-80-3-20';
        case 'vc2-4c-8gb':
            return '8-4-160-4-40';
        case 'vhp-1c-1gb-intel':
            return '1-1-25-2-6';
        case 'vhp-1c-2gb-intel':
            return '2-1-50-3-12';
        case 'vhp-1c-1gb-amd':
            return '1-1-25-2-6';
        case 'vhp-1c-2gb-amd':
            return '2-1-50-3-12';
        default:
            return false;
    }
}

function vultr2($plan){
    switch($plan){
        case 'vc2-1c-1gb':
            return '1-1-25-1-6';
        case 'vc2-1c-2gb':
            return '2-1-55-2-12';
        case 'vc2-2c-4gb':
            return '4-2-80-3-23';
        case 'vc2-4c-8gb':
            return '8-4-160-4-46';
        default:
            return false;
    }
}

function ovh($plan){
    switch($plan){
        case 'd2-2':
            return '2-1-25-8.6';
        case 'd2-4':
            return '4-2-50-17';
        case 'd2-8':
            return '8-4-50-31';
        default:
            return false;
    }
}

function ipv4_decode($text) {
    $text = str_replace(".cloudsnap.online", null, $text);
    $conversionTable = array(
        'a' => '1',
        'b' => '2',
        'c' => '3',
        'd' => '4',
        'e' => '5',
        'f' => '6',
        'j' => '7',
        'h' => '8',
        'i' => '9',
        'k' => '0',
        'p' => '.',
    );

    $decodedText = str_replace(array_keys($conversionTable), array_values($conversionTable), $text);

    return $decodedText;
}
function gcore($plan){
    switch($plan){
        case 'g2s-shared-1-1-25':
            return '1-1-25-5';
        case 'g2s-shared-1-2-25':
            return '2-1-25-7';
        default:
            return false;
    }
}

$coinall1 = file_get_contents('https://sc2.afzoneh-nevis.com/test/cloudsnap/sendall/coin.php');

$request44 = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?list_ipv4&api_token=$api_key");
$response44 = json_decode($request44, true);
foreach ($response44 as $match) {
    $from_id = explode("-",$match['name'])[0];
    $uuid = $match['id'];
    if($match['ipv_id'] == null and isset($from_id)){
        $payhour = intval($euro/30/24);
        if(is_numeric($from_id)){
            $result = mysqli_query($db, "SELECT * FROM users WHERE `user_id` = $from_id");
            if(mysqli_num_rows($result) > 0){
                $user = mysqli_fetch_assoc($result);
                update('users', ['coin' => $user['coin'] - $payhour], ['user_id' => $from_id]);
                if($user['coin'] >= $payhour){
                    $online15++;
                    $payconfirm15+=$payhour;
                }else{
                    file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?delete_ipv&id=$uuid&api_token=$api_key");
                    $delete15++;
                }
            }
        }
    }
}
$request44 = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?list_ipv4&api_token=$api_key_hetzner");
$response44 = json_decode($request44, true);
foreach ($response44 as $match) {
    $from_id = explode("-",$match['name'])[0];
    $uuid = $match['id'];
    if($match['ipv_id'] == null and isset($from_id)){
        $payhour = intval($euro/30/24);
        if(is_numeric($from_id)){
            $result = mysqli_query($db, "SELECT * FROM users WHERE `user_id` = $from_id");
            if(mysqli_num_rows($result) > 0){
                $user = mysqli_fetch_assoc($result);
                update('users', ['coin' => $user['coin'] - $payhour], ['user_id' => $from_id]);
                if($user['coin'] >= $payhour){
                    $online16++;
                    $payconfirm16+=$payhour;
                }else{
                    file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?delete_ipv&id=$uuid&api_token=$api_key_hetzner");
                    $delete16++;
                }
            }
        }
    }
}

$request44 = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?list_snapshot&api_token=$api_key");
$response44 = json_decode($request44, true);
foreach ($response44['images'] as $match) {
    $from_id = explode("-",$match['description'])[0];
    $uuid = $match['id'];
    if(isset($match['image_size']) and isset($from_id)){
        $gb = ceil($match['image_size']);
        $gb = $gb * 100;
        if(is_numeric($from_id)){
            $result = mysqli_query($db, "SELECT * FROM users WHERE `user_id` = $from_id");
            if(mysqli_num_rows($result) > 0){
                $user = mysqli_fetch_assoc($result);
                update('users', ['coin' => $user['coin'] - $gb], ['user_id' => $from_id]);
                if($user['coin'] >= $gb){
                    if(file_exists("time_server/hetzner/$uuid")){
                        unlink("time_server/hetzner/$uuid");
                    }
                    $online13++;
                    $payconfirm13+=$gb;
                }else{
                    if(!file_exists("time_server/hetzner/$uuid")){
                        file_put_contents("time_server/hetzner/$uuid",'1');
                    }
                    if(file_exists("time_server/hetzner/$uuid")){
                        $plus = file_get_contents("time_server/hetzner/$uuid") + 1;
                        file_put_contents("time_server/hetzner/$uuid",$plus);
                    }else{
                        file_put_contents("time_server/hetzner/$uuid",'1');
                    }
                    if(file_get_contents("time_server/hetzner/$uuid") >= '12'){
                        file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?del_snapshot&api_token=$api_key&id=$uuid");
                        unlink("time_server/hetzner/$uuid");
                        $delete13++;
                    }
                }
            }
        }
    }
}

$request44 = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?list_snapshot&api_token=$api_key_hetzner");
$response44 = json_decode($request44, true);
foreach ($response44['images'] as $match) {
    $from_id = explode("-",$match['description'])[0];
    $uuid = $match['id'];
    if(isset($match['image_size']) and isset($from_id)){
        $gb = ceil($match['image_size']);
        $gb = $gb * 100;
        if(is_numeric($from_id)){
            $result = mysqli_query($db, "SELECT * FROM users WHERE `user_id` = $from_id");
            if(mysqli_num_rows($result) > 0){
                $user = mysqli_fetch_assoc($result);
                update('users', ['coin' => $user['coin'] - $gb], ['user_id' => $from_id]);
                if($user['coin'] >= $gb){
                    if(file_exists("time_server/hetzner/$uuid")){
                        unlink("time_server/hetzner/$uuid");
                    }
                    $online14++;
                    $payconfirm14+=$gb;
                }else{
                    if(!file_exists("time_server/hetzner/$uuid")){
                        file_put_contents("time_server/hetzner/$uuid",'1');
                    }
                    if(file_exists("time_server/hetzner/$uuid")){
                        $plus = file_get_contents("time_server/hetzner/$uuid") + 1;
                        file_put_contents("time_server/hetzner/$uuid",$plus);
                    }else{
                        file_put_contents("time_server/hetzner/$uuid",'1');
                    }
                    if(file_get_contents("time_server/hetzner/$uuid") >= '12'){
                        file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?del_snapshot&api_token=$api_key_hetzner&id=$uuid");
                        unlink("time_server/hetzner/$uuid");
                        $delete14++;
                    }
                }
            }
        }
    }
}
$gcore1 = file_get_contents('https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/gcore.php?list&reg=116');
$response = json_decode($gcore1 , true);
foreach ($response['results'] as $server) {
    $from_id = explode("-",$server['instance_name'])[0];
    if(is_numeric($from_id)){
        $uuid = $server['instance_id'];
        $ip = $server['addresses']['pub_net'][0]['addr'];
        $user = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `users` WHERE `user_id` = $from_id"));
        if($user){
            $get_info = gcore($server['flavor']['flavor_name']);
            $payment = explode("-",$get_info)[3] * $euro;
            $payhour = intval($payment/30/24);
            update('users', ['coin' => $user['coin'] - $payhour], ['user_id' => $from_id]);
            if($user['coin'] >= $payhour){
                if(file_exists("time_server/gcore/$uuid")){
                    unlink("time_server/gcore/$uuid");
                    file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/gcore.php?req&post=POST&id=$uuid&loc=116&url=start");
                }
                if('20000' >= $user['coin']){
                    bot('sendMessage',[
                        'chat_id'=>$from_id,
                        'text'=>"⬇️ موجودی شما کمتر از 20,000 تومان است و بزودی سرویس شما درصورت شارژ نکردن مجدد حساب خاموش میشود ."
                    ]);
                }
                $online20++;
                $payconfirm20+=$payhour;
            }else{
                file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/gcore.php?req&post=POST&id=$uuid&loc=116&url=stop");
                $offline20++;
                $paynot20+=$payhour;
                if (file_exists("time_server/gcore/$uuid")) {
                    $plus = intval(file_get_contents("time_server/gcore/$uuid")) + 1;
                    file_put_contents("time_server/gcore/$uuid", $plus);
                } else {
                    file_put_contents("time_server/gcore/$uuid", '1');
                }
                if(file_get_contents("time_server/gcore/$uuid") >= '12'){
                    file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/gcore.php?req&post=DELETE&id=$uuid&loc=116");
                    unlink("time_server/gcore/$uuid");
                    $delete20++;
                }
            }
            
        }
    }
}
$gcore1 = file_get_contents('https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/gcore.php?list&reg=38');
$response = json_decode($gcore1 , true);
foreach ($response['results'] as $server) {
    $from_id = explode("-",$server['instance_name'])[0];
    if(is_numeric($from_id)){
        $uuid = $server['instance_id'];
        $ip = $server['addresses']['pub_net'][0]['addr'];
        $user = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `users` WHERE `user_id` = $from_id"));
        if($user){
            $get_info = gcore($server['flavor']['flavor_name']);
            $payment = explode("-",$get_info)[3] * $euro;
            $payhour = intval($payment/30/24);
            update('users', ['coin' => $user['coin'] - $payhour], ['user_id' => $from_id]);
            if($user['coin'] >= $payhour){
                if(file_exists("time_server/gcore/$uuid")){
                    unlink("time_server/gcore/$uuid");
                    file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/gcore.php?req&post=POST&id=$uuid&loc=38&url=start");
                }
                if('20000' >= $user['coin']){
                    bot('sendMessage',[
                        'chat_id'=>$from_id,
                        'text'=>"⬇️ موجودی شما کمتر از 20,000 تومان است و بزودی سرویس شما درصورت شارژ نکردن مجدد حساب خاموش میشود ."
                    ]);
                }
                $online20++;
                $payconfirm20+=$payhour;
            }else{
                file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/gcore.php?req&post=POST&id=$uuid&loc=38&url=stop");
                $offline20++;
                $paynot20+=$payhour;
                if (file_exists("time_server/gcore/$uuid")) {
                    $plus = intval(file_get_contents("time_server/gcore/$uuid")) + 1;
                    file_put_contents("time_server/gcore/$uuid", $plus);
                } else {
                    file_put_contents("time_server/gcore/$uuid", '1');
                }
                if(file_get_contents("time_server/gcore/$uuid") >= '12'){
                    file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/gcore.php?req&post=DELETE&id=$uuid&loc=38");
                    unlink("time_server/gcore/$uuid");
                    $delete20++;
                }
            }
        }
    }
}
$gcore1 = file_get_contents('https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/gcore.php?list&reg=104');
$response = json_decode($gcore1 , true);
foreach ($response['results'] as $server) {
    $from_id = explode("-",$server['instance_name'])[0];
    if(is_numeric($from_id)){
        $uuid = $server['instance_id'];
        $ip = $server['addresses']['pub_net'][0]['addr'];
        $user = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `users` WHERE `user_id` = $from_id"));
        if($user){
            $get_info = gcore($server['flavor']['flavor_name']);
            $payment = explode("-",$get_info)[3] * $euro;
            $payhour = intval($payment/30/24);
            update('users', ['coin' => $user['coin'] - $payhour], ['user_id' => $from_id]);
            if($user['coin'] >= $payhour){
                if(file_exists("time_server/gcore/$uuid")){
                    unlink("time_server/gcore/$uuid");
                    file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/gcore.php?req&post=POST&id=$uuid&loc=104&url=start");
                }
                if('20000' >= $user['coin']){
                    bot('sendMessage',[
                        'chat_id'=>$from_id,
                        'text'=>"⬇️ موجودی شما کمتر از 20,000 تومان است و بزودی سرویس شما درصورت شارژ نکردن مجدد حساب خاموش میشود ."
                    ]);
                }
                $online20++;
                $payconfirm20+=$payhour;
            }else{
                file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/gcore.php?req&post=POST&id=$uuid&loc=104&url=stop");
                $offline20++;
                $paynot20+=$payhour;
                if (file_exists("time_server/gcore/$uuid")) {
                    $plus = intval(file_get_contents("time_server/gcore/$uuid")) + 1;
                    file_put_contents("time_server/gcore/$uuid", $plus);
                } else {
                    file_put_contents("time_server/gcore/$uuid", '1');
                }
                if(file_get_contents("time_server/gcore/$uuid") >= '12'){
                    file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/gcore.php?req&post=DELETE&id=$uuid&loc=116");
                    unlink("time_server/gcore/$uuid");
                    $delete20++;
                }
            }
        }
    }
}
$ovhlist = file_get_contents('https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/ovh.php?list_server');
$response = json_decode($ovhlist , true);
foreach ($response as $server) {
    $from_id = explode("-",$server['name'])[0];
    $uuid = $server['id'];
    $ip = $server['ipAddresses']['0']['ip'];
    $user = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `users` WHERE `user_id` = $from_id"));
    if($user){
        $get_info = ovh(explode(".",$server['planCode'])[0]);
        $payment = explode("-",$get_info)[3] * $euro;
        $payhour = intval($payment/30/24);
        update('users', ['coin' => $user['coin'] - $payhour], ['user_id' => $from_id]);
        if($user['coin'] >= $payhour){
            if(file_exists("time_server/ovh/$uuid")){
                unlink("time_server/ovh/$uuid");
                file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/ovh.php?poweron&id=$uuid");
            }
            if('20000' >= $user['coin']){
                bot('sendMessage',[
                    'chat_id'=>$from_id,
                    'text'=>"⬇️ موجودی شما کمتر از 20,000 تومان است و بزودی سرویس شما درصورت شارژ نکردن مجدد حساب خاموش میشود ."
                ]);
            }
            $online4++;
            $payconfirm4+=$payhour;
        }else{
            file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/ovh.php?poweroff&id=$uuid");
            $offline4++;
            $paynot4+=$payhour;
            if (file_exists("time_server/ovh/$uuid")) {
                $plus = intval(file_get_contents("time_server/ovh/$uuid")) + 1;
                file_put_contents("time_server/ovh/$uuid", $plus);
            } else {
                file_put_contents("time_server/ovh/$uuid", '1');
            }
            if(file_get_contents("time_server/ovh/$uuid") >= '12'){
                file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/ovh.php?delete&id=$uuid");
                unlink("time_server/ovh/$uuid");
                $delete4++;
            }
        }
        
    }
}




include_once '/www/wwwroot/sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/virtua.php';
$virtuaClient = new virtua();
$response = json_decode($virtuaClient->list_server() , true);
foreach ($response['cloud_servers'] as $server) {
    $from_id = explode("-",$server['label'])[0];
    $uuid = $server['uuid'];
    $user = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `users` WHERE `user_id` = $from_id"));
    if($user){
        $payment = $server['offer']['price_month'] * $euro * 1.2;
        $payhour = intval($payment/30/24);
        update('users', ['coin' => $user['coin'] - $payhour], ['user_id' => $from_id]);
        if($user['coin'] >= $payhour){
            if(file_exists("time_server/virtua/$uuid")){
                unlink("time_server/virtua/$uuid");
                $virtuaClient1 = new virtua();
                $virtuaClient1->start($uuid);
            }
            if('20000' >= $user['coin']){
                bot('sendMessage',[
                    'chat_id'=>$from_id,
                    'text'=>"⬇️ موجودی شما کمتر از 20,000 تومان است و بزودی سرویس شما درصورت شارژ نکردن مجدد حساب خاموش میشود ."
                ]);
            }
            $online3++;
            $payconfirm3+=$payhour;
        }else{
            $offline3++;
            $paynot3+=$payhour;
            if(file_exists("time_server/virtua/{$server['ip_address']['address']}")){
                $plus = file_get_contents("time_server/virtua/{$server['ip_address']['address']}") + 1;
                file_put_contents("time_server/virtua/{$server['ip_address']['address']}",$plus);
            }else{
                $virtuaClient2 = new virtua();
                $virtuaClient2->stop($uuid);
                file_put_contents("time_server/virtua/{$server['ip_address']['address']}",'1');
            }
            if(file_get_contents("time_server/virtua/{$server['ip_address']['address']}") >= '12'){
                $virtuaClient3 = new virtua();
                $virtuaClient3->delet($uuid);
                unlink("time_server/virtua/{$server['ip_address']['address']}");
                $delete3++;
            }
        }
        
    }
}
$request = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?float_list&api_token=$api_key");
$response = json_decode($request, true);
foreach ($response as $decoded) {
    $from_id = explode("-",$decoded['name'])[0];
    $user = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `users` WHERE `user_id` = $from_id"));
    $payment = $floatip_coin * $euro;
    $payhour = intval($payment/30/24);
    $id_server = $decoded['id'];
    update('users', ['coin' => $user['coin'] - $payhour], ['user_id' => $from_id]);
    if($user['coin'] >= $payhour){
        if('20000' >= $user['coin']){
            bot('sendMessage',[
                'chat_id'=>$from_id,
                'text'=>"⬇️ موجودی شما کمتر از 20,000 تومان است و بزودی سرویس شما درصورت شارژ نکردن مجدد حساب خاموش میشود ."
            ]);
        }
        $online8++;
        $payconfirm8+=$payhour;
    }else{
        file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?float_del&api_token=$api_key&id=$id_server");
        $delete8++;
        
    }
}

$request = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?float_list&api_token=$api_key_hetzner");
$response = json_decode($request, true);
foreach ($response as $decoded) {
    $from_id = explode("-",$decoded['name'])[0];
    $user = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `users` WHERE `user_id` = $from_id"));
    $payment = $floatip_coin * $euro;
    $payhour = intval($payment/30/24);
    $id_server = $decoded['id'];
    update('users', ['coin' => $user['coin'] - $payhour], ['user_id' => $from_id]);
    if($user['coin'] >= $payhour){
        if('20000' >= $user['coin']){
            bot('sendMessage',[
                'chat_id'=>$from_id,
                'text'=>"⬇️ موجودی شما کمتر از 20,000 تومان است و بزودی سرویس شما درصورت شارژ نکردن مجدد حساب خاموش میشود ."
            ]);
        }
        $online9++;
        $payconfirm9+=$payhour;
    }else{
        file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?float_del&api_token=$api_key_hetzner&id=$id_server");
        $delete9++;
        
    }
}

# hetzner 
$request = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?list_all&api_token=$api_key");
$response = json_decode($request, true);

foreach ($response as $decoded) {
    $from_id = explode("-",$decoded['name'])[0];
    
    $get_info = info($decoded['model']);
    $payment = explode("-",$get_info)[3] * $euro;
    $payhour = intval($payment/30/24);
    $user = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `users` WHERE `user_id` = $from_id"));
    $id_server = $decoded['id'];
    $ipv4 = $decoded['ipv4'];
    if(isset(explode("-",$decoded['name'])[2])){
        $daysm = explode("-",$decoded['name'])[2] - $decoded['day'];
        if($daysm == '0'){
            file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?delete&api_token=$api_key&id=$id_server");
            $delete++;
        }
    }else{
        update('users', ['coin' => $user['coin'] - $payhour], ['user_id' => $from_id]);
        if($user['coin'] >= $payhour){
            if(file_exists("time_server/hetzner/$id_server")){
                unlink("time_server/hetzner/$id_server");
                file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?poweron&api_token=$api_key&id=$id_server");
            }
            if('20000' >= $user['coin']){
                bot('sendMessage',[
                    'chat_id'=>$from_id,
                    'text'=>"⬇️ موجودی شما کمتر از 20,000 تومان است و بزودی سرویس شما درصورت شارژ نکردن مجدد حساب خاموش میشود ."
                ]);
            }
            $online++;
            $payconfirm+=$payhour;
        }else{
            file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?poweroff&api_token=$api_key&id=$id_server");
            $offline++;
            $paynot+=$payhour;
            if(!file_exists("time_server/hetzner/$id_server")){
                file_put_contents("time_server/hetzner/$id_server",'1');
            }
            if(file_exists("time_server/hetzner/$id_server")){
                $plus = file_get_contents("time_server/hetzner/$id_server") + 1;
                file_put_contents("time_server/hetzner/$id_server",$plus);
            }else{
                file_put_contents("time_server/hetzner/$id_server",'1');
            }
            if(file_get_contents("time_server/hetzner/$id_server") >= '12'){
                file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?delete&api_token=$api_key&id=$id_server");
                unlink("time_server/hetzner/$id_server");
                $delete++;
            }
        }
    }
}
$request = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?list_all&api_token=$api_key_hetzner");
$response = json_decode($request, true);

foreach ($response as $decoded) {
    $from_id = explode("-",$decoded['name'])[0];
    
    $get_info = info3($decoded['model']);
    $payment = explode("-",$get_info)[3] * $euro;
    $payhour = intval($payment/30/24);
    $user = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `users` WHERE `user_id` = $from_id"));
    $id_server = $decoded['id'];
    $ipv4 = $decoded['ipv4'];
    
    if(isset(explode("-",$decoded['name'])[2])){
        $daysm = explode("-",$decoded['name'])[2] - $decoded['day'];
        if($daysm == '0'){
            file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?delete&api_token=$api_key_hetzner&id=$id_server");
            $delete++;
        }
    }else{
        update('users', ['coin' => $user['coin'] - $payhour], ['user_id' => $from_id]);
        if($user['coin'] >= $payhour){
            if(file_exists("time_server/hetzner/$id_server")){
                unlink("time_server/hetzner/$id_server");
                file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?poweron&api_token=$api_key_hetzner&id=$id_server");
            }
            if('20000' >= $user['coin']){
                bot('sendMessage',[
                    'chat_id'=>$from_id,
                    'text'=>"⬇️ موجودی شما کمتر از 20,000 تومان است و بزودی سرویس شما درصورت شارژ نکردن مجدد حساب خاموش میشود ."
                ]);
            }
            $online10++;
            $payconfirm10+=$payhour;
        }else{
            file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?poweroff&api_token=$api_key_hetzner&id=$id_server");
            $offline10++;
            $paynot10+=$payhour;
            if(!file_exists("time_server/hetzner/$id_server")){
                file_put_contents("time_server/hetzner/$id_server",'1');
            }
            if(file_exists("time_server/hetzner/$id_server")){
                $plus = file_get_contents("time_server/hetzner/$id_server") + 1;
                file_put_contents("time_server/hetzner/$id_server",$plus);
            }else{
                file_put_contents("time_server/hetzner/$id_server",'1');
            }
            if(file_get_contents("time_server/hetzner/$id_server") >= '12'){
                file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?delete&api_token=$api_key_hetzner&id=$id_server");
                unlink("time_server/hetzner/$id_server");
                $delete10++;
            }
        }
    }
}

# linode
$maxAttempts1 = 10;
$attempts1 = 0;
$response1 = null;

while($attempts < $maxAttempts1 && is_null($response1)) {
    $request = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/linode.php?list");
    $response1 = json_decode($request, true);
    $maxAttempts1++;
}

if(!is_null($response1)) {
    foreach ($response1['data'] as $server) {
        $from_id = explode("-",$server['label'])[0];
        $user = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `users` WHERE `user_id` = $from_id"));
        $id_server = $server['id'];
        $ipv4 = $server['ipv4'][0];
        if ($user){
            $get_info = linode($server['type']);
            $payment = explode("-",$get_info)[4] * $euro;
            $payhour = intval($payment/30/24);
            $expireDate = strtotime($server['created']);
            $currentDate = time();
            $timeDifference = $expireDate - $currentDate;
            $daysDifference = round($timeDifference / (60 * 60 * 24)); 
            if(explode("-",$server['label'])[2] != null){
                $dayss = explode("-",$server['label'])[2];
                if($dayss == '1'){
                    $dayss = '2';
                }
                $daysDifference = $dayss + $daysDifference;
                if($daysDifference <= 1){
                    file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/linode.php?delete&id=$id_server");
                    $delete1++;
                }else{
                    $online1++;
                }
            }else{
                update('users', ['coin' => $user['coin'] - $payhour], ['user_id' => $from_id]);
                if($user['coin'] >= $payhour){
                    
                        
                    if(file_exists("time_server/linode/$id_server")){
                        unlink("time_server/linode/$id_server");
                        file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/linode.php?on&id=$id_server");
                    }
                    if('20000' >= $user['coin']){
                        bot('sendMessage',[
                            'chat_id'=>$from_id,
                            'text'=>"⬇️ موجودی شما کمتر از 20,000 تومان است و بزودی سرویس شما درصورت شارژ نکردن مجدد حساب خاموش میشود ."
                        ]);
                    }
                    $online1++;
                    $payconfirm1+=$payhour;
                }else{
                    $offline1++;
                    $paynot1+=$payhour;
                    file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/linode.php?off&id=$id_server");
                    if(!file_exists("time_server/linode/$id_server")){
                        file_put_contents("time_server/linode/$id_server",'1');
                    }
                    if(file_exists("time_server/linode/$id_server")){
                        $plus = file_get_contents("time_server/linode/$id_server") + 1;
                        file_put_contents("time_server/linode/$id_server",$plus);
                    }else{
                        file_put_contents("time_server/linode/$id_server",'1');
                    }
                    if(file_get_contents("time_server/linode/$id_server") >= '12'){
                        file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/linode.php?delete&id=$id_server");
                        unlink("time_server/linode/$id_server");
                        $delete1++;
                    }
                }
            }
        }
    }
}
# Vultr
$maxAttempts = 10;
$attempts = 0;
$response = null;

while($attempts < $maxAttempts && is_null($response)) {
    $request = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/vultr.php?list");
    $response = json_decode($request, true);
    $attempts++;
}
if(!is_null($response)) {
    foreach ($response['instances'] as $droplet) {
        $from_id = explode("-",$droplet['label'])[0];
        $from_id = (int)$from_id;
        $id_server = $droplet['id'];
        $ipv4 = $droplet['main_ip'];
        $user = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `users` WHERE `user_id` = '$from_id'"));
        if ($user){
            $get_info = vultr($droplet['plan']);
            $payment = explode("-",$get_info)[4] * $euro;
            $payhour = intval($payment/30/24);
            
            $dayss = explode("-",$droplet['label'])[2];
            if($dayss == '1'){
                $dayss = '2';
            }
            $expireDate = strtotime($droplet['date_created']);
            $currentDate = time();
            $timeDifference = $expireDate - $currentDate;
            $daysDifference = round($timeDifference / (60 * 60 * 24)); 
            $daysDifference = $dayss + $daysDifference;
            if(explode("-",$droplet['label'])[2] != null){
                if($daysDifference <= 1){
                    file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/vultr.php?del=$id_server");
                    $delete2++;
                }
                $online2++;
            }else{ 
                update('users', ['coin' => $user['coin'] - $payhour], ['user_id' => $from_id]);
                if($user['coin'] >= $payhour){
                    
                    if(file_exists("time_server/vultr/$id_server")){
                        unlink("time_server/vultr/$id_server");
                        file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/vultr.php?start=$id_server");
                    }
                    if('20000' >= $user['coin']){
                        bot('sendMessage',[
                            'chat_id'=>$from_id,
                            'text'=>"⬇️ موجودی شما کمتر از 20,000 تومان است و بزودی سرویس شما درصورت شارژ نکردن مجدد حساب خاموش میشود ."
                        ]);
                    }
                    $online2++;
                    $payconfirm2+=$payhour;
                }else{
                    $offline2++;
                    $paynot2+=$payhour;
                    file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/vultr.php?stop=$id_server&n=3");
                    if(!file_exists("time_server/vultr/$id_server")){
                        file_put_contents("time_server/vultr/$id_server",'1');
                    }
                    if(file_exists("time_server/vultr/$id_server")){
                        $plus = file_get_contents("time_server/vultr/$id_server") + 1;
                        file_put_contents("time_server/vultr/$id_server",$plus);
                    }else{
                        file_put_contents("time_server/vultr/$id_server",'1');
                    }
                    if(file_get_contents("time_server/vultr/$id_server") >= '12'){
                        file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/vultr.php?del=$id_server");
                        unlink("time_server/vultr/$id_server");
                        $delete2++;
                    }
                }
            }
        }
    }
}
$request = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?list_all&api_token=kPalXsQG6EpQe1MvSe2TxNUfUkv9hsDuTi6XfbbpFj6PpkQ5Fin0nH9mTzIQdHZ5");
$response = json_decode($request, true);

foreach ($response as $decoded) {
    $from_id = explode("-",$decoded['name'])[0];
    
    $get_info = info2($decoded['model']);
    $payment = explode("-",$get_info)[3] * $euro;
    $payhour = intval($payment/30/24);
    $user = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `users` WHERE `user_id` = $from_id"));
    $id_server = $decoded['id'];
    $ipv4 = $decoded['ipv4'];
    update('users', ['coin' => $user['coin'] - $payhour], ['user_id' => $from_id]);
    if($user['coin'] >= $payhour){
        if(file_exists("time_server/hetzner/$id_server")){
            unlink("time_server/hetzner/$id_server");
            file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?poweron&api_token=kPalXsQG6EpQe1MvSe2TxNUfUkv9hsDuTi6XfbbpFj6PpkQ5Fin0nH9mTzIQdHZ5&id=$id_server");
        }
        if('20000' >= $user['coin']){
            bot('sendMessage',[
                'chat_id'=>$from_id,
                'text'=>"⬇️ موجودی شما کمتر از 20,000 تومان است و بزودی سرویس شما درصورت شارژ نکردن مجدد حساب خاموش میشود ."
            ]);
        }
        $online5++;
        $payconfirm5+=$payhour;
    }else{
        file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?poweroff&api_token=kPalXsQG6EpQe1MvSe2TxNUfUkv9hsDuTi6XfbbpFj6PpkQ5Fin0nH9mTzIQdHZ5&id=$id_server");
        $offline5++;
        $paynot5+=$payhour;
        if(!file_exists("time_server/hetzner/$id_server")){
            file_put_contents("time_server/hetzner/$id_server",'1');
        }
        if(file_exists("time_server/hetzner/$id_server")){
            $plus = file_get_contents("time_server/hetzner/$id_server") + 1;
            file_put_contents("time_server/hetzner/$id_server",$plus);
        }else{
            file_put_contents("time_server/hetzner/$id_server",'1');
        }
        if(file_get_contents("time_server/hetzner/$id_server") >= '12'){
            file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/api.php?delete&api_token=kPalXsQG6EpQe1MvSe2TxNUfUkv9hsDuTi6XfbbpFj6PpkQ5Fin0nH9mTzIQdHZ5&id=$id_server");
            unlink("time_server/hetzner/$id_server");
            $delete5++;
        }
    }
}


# cracky

$request = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/linode.php?list&api=$api_key_linode");
$response1 = json_decode($request, true);

foreach ($response1['data'] as $server) {
    $from_id = explode("-",$server['label'])[0];
    $user = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `users` WHERE `user_id` = $from_id"));
    $id_server = $server['id'];
    $ipv4 = $server['ipv4'][0];
    if ($user){
        $get_info = linode($server['type']);
        $payment = explode("-",$get_info)[4] * $cracky;
        $payhour = intval($payment/30/24);
        update('users', ['coin' => $user['coin'] - $payhour], ['user_id' => $from_id]);
        if($user['coin'] >= $payhour){
            if(file_exists("time_server/linode/$id_server")){
                unlink("time_server/linode/$id_server");
                file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/linode.php?api=$api_key_linode&on&id=$id_server");
            }
            if('20000' >= $user['coin']){
                bot('sendMessage',[
                    'chat_id'=>$from_id,
                    'text'=>"⬇️ موجودی شما کمتر از 20,000 تومان است و بزودی سرویس شما درصورت شارژ نکردن مجدد حساب خاموش میشود ."
                ]);
            }
            $online6++;
            $payconfirm6+=$payhour;
        }else{
            $offline6++;
            $paynot6+=$payhour;
            file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/linode.php?api=$api_key_linode&off&id=$id_server");
            if(!file_exists("time_server/linode/$id_server")){
                file_put_contents("time_server/linode/$id_server",'1');
            }
            if(file_exists("time_server/linode/$id_server")){
                $plus = file_get_contents("time_server/linode/$id_server") + 1;
                file_put_contents("time_server/linode/$id_server",$plus);
            }else{
                file_put_contents("time_server/linode/$id_server",'1');
            }
            if(file_get_contents("time_server/linode/$id_server") >= '12'){
                file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/linode.php?api=$api_key_linode&delete&id=$id_server");
                unlink("time_server/linode/$id_server");
                $delete6++;
            }
        }
    }
}

$request = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/vultr.php?api=$api_key_vultr&list");
$response = json_decode($request, true);

foreach ($response['instances'] as $droplet) {
    $from_id = explode("-",$droplet['label'])[0];
    $from_id = (int)$from_id;
    $id_server = $droplet['id'];
    $ipv4 = $droplet['main_ip'];
    $user = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `users` WHERE `user_id` = '$from_id'"));
    if ($user){
        $get_info = vultr2($droplet['plan']);
        $payment = explode("-",$get_info)[4] * $cracky;
        $payhour = intval($payment/30/24);
        update('users', ['coin' => $user['coin'] - $payhour], ['user_id' => $from_id]);
        if($user['coin'] >= $payhour){
            
            if(file_exists("time_server/vultr/$id_server")){
                unlink("time_server/vultr/$id_server");
                file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/vultr.php?api=$api_key_vultr&start=$id_server");
            }
            if('20000' >= $user['coin']){
                bot('sendMessage',[
                    'chat_id'=>$from_id,
                    'text'=>"⬇️ موجودی شما کمتر از 20,000 تومان است و بزودی سرویس شما درصورت شارژ نکردن مجدد حساب خاموش میشود ."
                ]);
            }
            $online7++;
            $payconfirm7+=$payhour;
        }else{
            $offline7++;
            $paynot7+=$payhour;
            file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/vultr.php?api=$api_key_vultr&stop=$id_server&n=3");
            if(!file_exists("time_server/vultr/$id_server")){
                file_put_contents("time_server/vultr/$id_server",'1');
            }
            if(file_exists("time_server/vultr/$id_server")){
                $plus = file_get_contents("time_server/vultr/$id_server") + 1;
                file_put_contents("time_server/vultr/$id_server",$plus);
            }else{
                file_put_contents("time_server/vultr/$id_server",'1');
            }
            if(file_get_contents("time_server/vultr/$id_server") >= '12'){
                file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/vultr.php?api=$api_key_vultr&del=$id_server");
                unlink("time_server/vultr/$id_server");
                $delete7++;
            }
        }
    }
}


mysqli_close($db);
$coinall = file_get_contents('https://sc2.afzoneh-nevis.com/test/cloudsnap/sendall/coin.php');
$ksr_all = $payconfirm + $payconfirm1 + $payconfirm2 + $payconfirm3 + $payconfirm4 + $payconfirm5 + $payconfirm10 + $payconfirm8 + $payconfirm9 + $payconfirm7;
$texts = "Hetzner
ON 🇮🇷 $online |🇺🇦$online10
PAY 🇮🇷 $payconfirm |🇺🇦$payconfirm10
OFF 🇮🇷 $offline |🇺🇦$offline10
DEL 🇮🇷 $delete |🇺🇦$delete10

SNAPSHOTS
ON: 🇮🇷$online13 |🇺🇦$online14
PAY: 🇮🇷$payconfirm13 |🇺🇦$payconfirm14
DEL: 🇮🇷$delete13 |🇺🇦$delete14

PRIMARY IP
ON: 🇺🇦$online16 |🇮🇷$online15
OFF: 🇺🇦$delete16 |🇮🇷$delete15
PAY: 🇺🇦$payconfirm16 |🇮🇷$payconfirm15

FLOATING IP
ON: 🇮🇷$online8 |🇺🇦$online9
PAY: 🇮🇷$payconfirm8 |🇺🇦$payconfirm9
DEL: 🇮🇷$delete8 |🇺🇦$delete9

Linode|Vultr
ON: $online1|$online2
PAY: $payconfirm1|$payconfirm2
OFF: $offline1|$offline2
DEL: $delete1|$delete2

Virtua|Ovh|Gcore
ON: $online3|$online4|$online20
PAY: $payconfirm3|$payconfirm4|$payconfirm20
OFF: $offline3|$offline4|$offline20
DEL: $delete3|$delete4|$delete20

قبل کسر: $coinall1
کسر شده: $ksr_all
بعد کسر: $coinall";
bot('sendMessage',[
    'chat_id'=>"5802008071",
    'text'=>"$texts"
]);
echo 'ok';
?>