<?php

ini_set('max_execution_time','250');
set_time_limit(250);
ini_set('memory_limit' , '-1');

include 'database.php';

function bot($method, $data = []){
    $url  = 'https://api.telegram.org/bot'. TokEn_BoTs. '/'.$method;
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
    $res = curl_exec($curl);
    curl_close($curl);
    return $res;
}
function linode($plan){
    switch($plan){
        case 'g6-nanode-1':
            return '1-1-25-1-5.4';
        case 'g6-standard-1':
            return '2-1-50-2-13';
        case 'g6-standard-2':
            return '4-2-80-4-26';
        case 'g6-standard-4':
            return '8-4-160-5-52';
        case 'g6-standard-6':
            return '16-6-320-8-104';
        case 'g6-standard-8':
            return '32-8-640-16-208';
        default:
            return false;
    }
}
function vultr($plan){
    switch($plan){
        case 'vc2-1c-1gb':
            return '1-1-25-1-5.8';
        case 'vc2-1c-2gb':
            return '2-1-55-2-11.6';
        case 'vc2-2c-4gb':
            return '4-2-80-3-23';
        case 'vc2-4c-8gb':
            return '8-4-160-4-46';
        case 'vhp-1c-1gb-intel':
            return '1-1-25-2-7.5';
        case 'vhp-1c-2gb-intel':
            return '2-1-50-3-15';
        case 'vhp-1c-1gb-amd':
            return '1-1-25-2-7.5';
        case 'vhp-1c-2gb-amd':
            return '2-1-50-3-15';
        default:
            return false;
    }
}

# linode
$maxAttempts1 = 10;
$attempts1 = 0;
$response1 = null;

while($attempts < $maxAttempts1 && is_null($response1)) {
    $request = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/linode.php?list");
    $response1 = json_decode($request, true);
    $maxAttempts1++;
}

if(!is_null($response1)) {
    foreach ($response1['data'] as $server) {
        $from_id = explode("-",$server['label'])[0];
        $user = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `users` WHERE `user_id` = $from_id"));
        $id_server = $server['id'];
        if ($user){
            $get_info = linode($server['type']);
            $traffic = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/linode.php?band&id=$id_server");
            $tra = explode("-",$get_info)[3];
            
            $expireDate = strtotime($server['created']);
            $currentDate = time();
            $timeDifference = $expireDate - $currentDate;
            $daysDifference = round($timeDifference / (60 * 60 * 24)); 
            $daytocreate = explode("-",$daysDifference)[1] + 1;
            
            if(explode("-",$server['label'])[2] != null){
                if($traffic >= $tra){
                    file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/linode.php?off&id=$id_server");
                    $offlane_linode++;
                }else{
                    $online_linode++;
                }
            }else{
                $dateToCheck = new DateTime($server['created']);
                $currentDate = new DateTime();
                if ($dateToCheck < $currentDate->modify('first day of this month')) {
                    $currentDate = new DateTime();
                    $daytocreate = $currentDate->format('d');
                }
                $daytocreate1 = $tra / 30;
                $daytocreate2 = $daytocreate1 * $daytocreate;
                if($traffic >= $daytocreate2){
                    file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/linode.php?off&id=$id_server");
                    $offlane_linode++;
                }else{
                    $online_linode++;
                }
            }
        }
    }
}

# Vultr
$maxAttempts = 10;
$attempts = 0;
$response = null;

while ($attempts < $maxAttempts && is_null($response)) {
    $request = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/vultr.php?list");
    $response = json_decode($request, true);
    $attempts++;
}

if (!is_null($response)) {
    foreach ($response['instances'] as $droplet) {
        $labelParts = explode("-", $droplet['label']);

        if (count($labelParts) == 3 or count($labelParts) == 2) {
            $from_id = (int) $labelParts[0];
            $id_server = $droplet['id'];
            $user = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `users` WHERE `user_id` = '$from_id'"));

            if ($user) {
                $get_info = vultr($droplet['plan']);
                $traffic = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/vultr.php?band=$id_server");
                $tra = explode("-", $get_info)[3];

                $dayss = $labelParts[2];
                
                $createdDate = strtotime($droplet['date_created']);
                $currentTimestamp = time();
                
                $dateToCheck = new DateTime($droplet['date_created']);
                $currentDate = new DateTime();
                
                if ($dateToCheck < $currentDate->modify('first day of this month')) {
                    $currentDate = new DateTime();
                    $daysPassed = $currentDate->format('d');
                } else {
                    $daysPassed = round(($currentTimestamp - $createdDate) / (60 * 60 * 24) + 1);
                }
                
                if (!empty($dayss)) {
                    if ($tra > $traffic) {
                        $online_vultr++;
                    } else {
                        $offlane_vultr++;
                        file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/vultr.php?stop=$id_server&n=1");
                    }
                } else {
                    
                    $daytocreate = $tra / 30 * $daysPassed;
                    
                    if ($traffic >= $daytocreate) {
                        
                        $offlane_vultr++;
                        file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/vultr.php?stop=$id_server&n=2");
                    } else {
                        $online_vultr++;
                    }
                }
            }
        }
    }
}

$request = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/linode.php?list&api=$api_key_linode");
$response1 = json_decode($request, true);


foreach ($response1['data'] as $server) {
    $from_id = explode("-",$server['label'])[0];
    $user = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `users` WHERE `user_id` = $from_id"));
    $id_server = $server['id'];
    if ($user){
        $get_info = linode($server['type']);
        $traffic = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/linode.php?band&id=$id_server&api=$api_key_linode");
        $tra = explode("-",$get_info)[3];

        if($traffic >= $tra){
            file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/linode.php?delete&id=$id_server&api=$api_key_linode");
            $offlane_linode2++;
        }else{
            $online_linode2++;
        }
    }
}

$request = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/vultr.php?list&api=$api_key_vultr");
$response = json_decode($request, true);

foreach ($response['instances'] as $droplet) {
    $from_id = explode("-",$droplet['label'])[0];
    $from_id = (int)$from_id;
    if(isset(explode("-",$droplet['label'])[0]) and isset(explode("-",$droplet['label'])[1])){
        $id_server = $droplet['id'];
        $user = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `users` WHERE `user_id` = '$from_id'"));
        if ($user){
            $get_info = vultr($droplet['plan']);
            $traffic = file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/vultr.php?band=$id_server&api=$api_key_vultr");
            $tra = explode("-",$get_info)[3];
            if($tra > $traffic) {
                $online_vultr2++;
            }else{
                $offlane_vultr2++;
                file_get_contents("https://sc2.afzoneh-nevis.com/test/cloudsnap/API_randtests/vultr.php?del=$id_server&n=1&api=$api_key_vultr");
            }
        
        }
    }
}


bot('sendMessage',[
    'chat_id'=>"@dlsakdlkdklsjdkalsjdlkakjdlkasjd",
    'text'=>"
Linode
    
✅ Online : $online_linode
❌ Offline : $offlane_linode

Vultr
    
✅ Online : $online_vultr
❌ Offline : $offlane_vultr

"
]);
echo 'ok';